using System;
using System.Collections.Generic;
using System.Linq;

class Race
{
    static void Main()
    {
        Console.WriteLine("Uneti broj pocetnih tacaka n:");
        if (!int.TryParse(Console.ReadLine(), out int n) || n == 0)
        {
            Console.WriteLine("Nevalidan unos.");
            return;
        }

        Console.WriteLine("Uneti X koordinate tacaka razdvojene razmakom:");
        var xInput = Console.ReadLine().Split(' ').Select(long.Parse).Take(n).ToList();

        Console.WriteLine("Uneti Y koordinate tacaka razdvojene razmakom:");
        var yInput = Console.ReadLine().Split(' ').Select(long.Parse).Take(n).ToList();

        if (xInput.Count != n || yInput.Count != n)
        {
            Console.WriteLine("Greska pri unosu koordinata.");
            return;
        }

        long countEven = 0;
        long countOdd = 0;

        for (int i = 0; i < n; i++)
        {
            long x = xInput[i];
            long y = yInput[i];

            if (Math.Abs(x + y) % 2 == 0)
            {
                countEven++;
            }
            else
            {

                countOdd++;
            }
        }

        long totalGreetings = (countEven * (countEven - 1) / 2) + (countOdd * (countOdd - 1) / 2);

        long finalAnswer = 2 * totalGreetings;

        Console.WriteLine($"Ukupno pozdrava tokom trke: {finalAnswer}");
    }
}